function [meanimage,stderrimage,images,rotimages,corr_img] = ImageCorr2(channels,maxOffset,offset,ch_names)
    %ImageCorrNew(channels,maxOffset,offset);
    %
    %Usage example: [mean,stderr,im,rot]= ImageCorrNew({'syn.tif','psd.tif'},10,[490 100]);
    %
    if nargin < 3, offset = [1 1]; end
    c1 = channels{1,1};     %%set first stack to c1 variable
    c1images = size(c1,3);  %%get the number of images in the stack
    optSize=2*maxOffset*10+10;
    %maxHeight = size(c1,1);    %%get # of rows
    %maxWidth = size(c1,2);     %%get # of columns.
    images=[];
    rotimages=[];
    meanimage=[];
    stderrimage=[];
    %offset=[x,y];
    %if maxWidth/optSize < 1 || maxHeight/optSize < 1
    %    'Image is not big enough.  Please choose a smaller offset size.'
    %else
        
        [tmpimgs,tmprots,corr_img] = StackCorr(channels,optSize,offset(1),offset(2),ch_names);
        images=cat(3,images,tmpimgs);
        rotimages=cat(3,rotimages,tmprots);

        ratioimg=(images-rotimages)./(rotimages+images); %difference over sum normalization
        meanimage=mean(ratioimg,3); %average over all the slices of the stack
        stderrimage=std(ratioimg,0,3)/sqrt(length(ratioimg(1,1,:))); %%find std error
    %end
    

function [images,rotimages,corr_img] = StackCorr(channels,windowSize,offsetX,offsetY,ch_names)

    if nargin < 2, offsetX=1; offsetY=1; end

    %channels= {'Synapsin1.tif', 'Synapsin2.tif', 'Syn1T.tif', 'Maguk.tif', 'Gephryn.tif'};
    %channels= {'SynSImgTrans2.tif'};
    useMask=0;
    if useMask==1
        maskImage=tiffread2('mask.tif');
    end
    
    imgsize=windowSize; %how big our subimages are going to be.
    images=[];
    rotimages=[];
    
    h = waitbar(0,['Currently analyzing: ',ch_names{1}],'position',[20 300 275 50]);    %initialize progress bar.
    for c1 = 1:length(channels)
        waitbar((c1-1)/length(channels),h,['Currently Analyzing: ',ch_names{c1}]);   %update progress
        img1 = channels{1,c1};                  %%Load stack of interest
        n1images = size(channels{1,c1},3);      %%Get the number of slices of the stack
        %%c1
        istk2=[];
        rstk2=[];
        h2 = waitbar(0,['Comparing Channel: ',ch_names{1}],'position',[20 200 275 50]);    %initialize progress bar.
        for c2= 1:length(channels)
            waitbar((c2-1)/length(channels),h2,['Comparing Channel: ',ch_names{c2}]);   %update progress
            img2 = channels{1,c2};              %%Load Comparision Stack
            n2images = size(channels{1,c2},3);  %%Get the number of slaces of the stack
            istk=[];
            rstk=[];
            h3 = waitbar(0,'Processing Image: 1');    %initialize progress bar.
            for i = 1:n1images
                waitbar(i/n1images,h3,['Processing Image: ',num2str(i)]);   %update progress
                %compute the images patches
                warning off all;        %%off with the warnings
                sm1=img1(offsetY:offsetY+imgsize-1,offsetX:offsetX+imgsize-1,i);
                sm2=img2(offsetY:offsetY+imgsize-1,offsetX:offsetX+imgsize-1,i);
                %%store the images used as a reference
                sm1_tmp(:,:,i) = sm1;
                warning on all;         %%show me the warnings.

                if useMask==1
                    msm=maskImage(i).data(offsetY:offsetY+imgsize-1,offsetX:offsetX+imgsize-1);

                    conv=CorrelationComparison(min(sm1,msm),min(sm2,msm),1);
                    convrot=CorrelationComparison(min(sm1,msm),min(sm2',msm),1);
                else
                    conv=CorrelationComparison(sm1,sm2,1);
                    convrot=CorrelationComparison(sm1,sm2',1);
                end

                istk=cat(3,istk,conv);
                rstk=cat(3,rstk,convrot);
            end
            istk2=cat(1,istk2,istk);
            rstk2=cat(1,rstk2,rstk);
            name={channels{c1},channels{c2}};
            close(h3)   %close progress bar
            waitbar(c2/length(channels),h2,['Comparing Channel: ',ch_names{c2}]);   %update progress
        end
        images=cat(2,images,istk2);
        rotimages=cat(2,rotimages,rstk2);
        %%output acutal images used for correlation
        corr_img{1,c1} = sm1_tmp;
        sm1_temp = [];
        close(h2)   %close progress bar
        waitbar(c1/length(channels),h,['Currently Analyzing: ',ch_names{c1}]);   %update progress
    end
    close(h)        %close progress bar

function cconv=CorrelationComparison(img1, img2, scale)
    if nargin < 3, scale=1; end
    img1=imresize(img1,scale,'bicubic'); %scaling ability for subpixel comparison
    img2=imresize(img2,scale,'bicubic');
    bigsize=size(img2);
    offset=bigsize*0.05;
    newimg2=img2(round(offset(1)):round(bigsize(1)-offset(1)),round(offset(2)):round(bigsize(2)-offset(2)));
    newimg2=flipud(fliplr(newimg2)); %conv2 is MUCH faster, but requires one image to be flipped
    cconv=conv2(single(img1),single(newimg2),'valid');
